/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.actions;

import java.io.Closeable;
import org.eclipse.jface.wizard.IWizard;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.StartRecordingWizard;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.JVMSupportToolkit;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.wizards.AbstractWizardUserAction;

public class StartRecordingAction
extends AbstractWizardUserAction {
    private final FlightRecorderProvider recorder;

    public StartRecordingAction(FlightRecorderProvider recorder) {
        super(Messages.ACTION_START_RECORDING_LABEL, Messages.ACTION_START_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("jfr_on.png"));
        this.recorder = recorder;
    }

    public IWizard doCreateWizard() throws Exception {
        IConnectionHandle handle;
        block5: {
            StartRecordingWizard startRecordingWizard;
            handle = null;
            try {
                handle = this.recorder.getServerHandle().connect(Messages.ACTION_START_RECORDING_LABEL);
                IFlightRecorderService flrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
                if (flrService == null) {
                    throw new FlightRecorderException(JVMSupportToolkit.getNoFlightRecorderErrorMessage((IConnectionHandle)handle, (boolean)false));
                }
                if (!flrService.isEnabled() && !ControlPanel.askUserForEnable(flrService, Messages.COMMERCIAL_FEATURES_QUESTION)) break block5;
                MCFile recFile = ControlPanel.getDefaultRecordingFile(this.recorder.getServerHandle());
                RecordingWizardModel model = new RecordingWizardModel((IRecorderConfigurationService)flrService, recFile);
                this.recorder.resetWarning();
                startRecordingWizard = new StartRecordingWizard(model, this.recorder);
            }
            catch (Exception e) {
                try {
                    this.recorder.setWarning(e.getLocalizedMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(handle);
                    throw throwable;
                }
            }
            IOToolkit.closeSilently((Closeable)handle);
            return startRecordingWizard;
        }
        IOToolkit.closeSilently((Closeable)handle);
        return null;
    }
}

