/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.actions;

import java.io.Closeable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.DumpRecordingWizardModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.DumpRecordingWizardPage;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.ui.wizards.AbstractWizardUserAction;
import org.openjdk.jmc.ui.wizards.OnePageWizard;

public class DumpAnyRecordingAction
extends AbstractWizardUserAction {
    private final FlightRecorderProvider flightRecorder;

    public DumpAnyRecordingAction(FlightRecorderProvider flightRecorderProvider) {
        super(Messages.ACTION_DUMP_ANY_RECORDING_LABEL, Messages.ACTION_DUMP_ANY_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("jfr_dump.png"));
        this.flightRecorder = flightRecorderProvider;
    }

    public IWizard doCreateWizard() throws Exception {
        IConnectionHandle handle;
        block5: {
            handle = null;
            handle = this.flightRecorder.getServerHandle().connect(Messages.ACTION_DUMP_ANY_RECORDING_LABEL);
            RecordingProvider recording = this.flightRecorder.getSnapshotRecording(handle);
            if (recording == null) break block5;
            this.flightRecorder.resetWarning();
            OnePageWizard onePageWizard = new OnePageWizard((IWizardPage)new DumpRecordingWizardPage(new DumpRecordingWizardModel(recording)));
            IOToolkit.closeSilently((Closeable)handle);
            return onePageWizard;
        }
        try {
            try {
                throw new FlightRecorderException(NLS.bind((String)Messages.DUMP_ANY_RECORDING_ERROR_MSG, (Object)this.flightRecorder.getServerHandle().getServerDescriptor().getDisplayName()));
            }
            catch (Exception e) {
                this.flightRecorder.setWarning(e.getLocalizedMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(handle);
            throw throwable;
        }
    }
}

