/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.mbeanbrowser.notifications;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.management.Notification;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.console.ui.mbeanbrowser.notifications.Messages;
import org.openjdk.jmc.rjmx.services.IAttributeInfo;
import org.openjdk.jmc.rjmx.services.IReadOnlyAttribute;
import org.openjdk.jmc.rjmx.ui.attributes.AttributeTreeBuilder;
import org.openjdk.jmc.rjmx.util.internal.DefaultAttribute;
import org.openjdk.jmc.rjmx.util.internal.SimpleAttributeInfo;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ArrayProxy;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class MBeanNotificationLogInspector {
    public static final String MBEANBROWSER_NOTIFICATIONSTAB_LOGTREE_NAME = "mbeanbrowser.notificationsTab.LogInspectorTree";
    private final ColumnManager columnManager;
    private Object[] values = new Object[0];

    public MBeanNotificationLogInspector(Composite parent, FormToolkit toolkit, IMemento state) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.MBeanNotificationLogSectionPart_LOG_SECTION_TITLE);
        Tree tree = new Tree((Composite)section, 68354);
        section.setClient((Control)tree);
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        viewer.setInput((Object)new ArrayProxy(this::getValues));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        List<IColumn> columns = Arrays.asList(AttributeTreeBuilder.NAME, AttributeTreeBuilder.VALUE, AttributeTreeBuilder.TYPE);
        this.columnManager = ColumnManager.build((TreeViewer)viewer, columns, (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)tree));
        tree.setData("name", (Object)MBEANBROWSER_NOTIFICATIONSTAB_LOGTREE_NAME);
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    private Object[] getValues() {
        return this.values;
    }

    public void show(Stream<Notification> notifications) {
        this.values = notifications.map(NotificationValue::new).toArray();
        this.columnManager.getViewer().refresh();
    }

    public static DateFormat getDateFormat() {
        return NotificationValue.getDateFormat();
    }

    private static class NotificationValue
    extends DefaultAttribute {
        private static final DateFormat DATE_FORMAT;
        private static final String SECOND_FORMATTING = "ss";
        private static final String MILLIS_FORMATTING = ".SSS";
        private final Notification m_notification;
        private Collection<IReadOnlyAttribute> m_children;

        static {
            DateFormat defaultFormat = DateFormat.getDateTimeInstance(3, 2);
            if (defaultFormat instanceof SimpleDateFormat) {
                SimpleDateFormat format = (SimpleDateFormat)defaultFormat;
                String pattern = format.toPattern();
                int index = pattern.indexOf(SECOND_FORMATTING);
                defaultFormat = index >= 0 ? new SimpleDateFormat(pattern.replace(SECOND_FORMATTING, "ss.SSS")) : new SimpleDateFormat(String.valueOf(pattern) + MILLIS_FORMATTING);
            }
            DATE_FORMAT = defaultFormat;
        }

        public NotificationValue(Notification notification) {
            super(NotificationValue.createAttributeInfo(notification));
            this.m_notification = notification;
        }

        private static synchronized IAttributeInfo createAttributeInfo(Notification notification) {
            return new SimpleAttributeInfo(DATE_FORMAT.format(new Date(notification.getTimeStamp())), notification.getType());
        }

        public Object getValue() {
            return this.m_notification.getMessage();
        }

        public boolean hasChildren() {
            return true;
        }

        public Collection<IReadOnlyAttribute> getChildren() {
            if (this.m_children == null) {
                this.m_children = new ArrayList<IReadOnlyAttribute>();
                this.m_children.add((IReadOnlyAttribute)new DefaultAttribute(Messages.MBeanNotificationLogInspector_TIME_STAMP_LABEL, (Object)this.m_notification.getTimeStamp()));
                this.m_children.add((IReadOnlyAttribute)new DefaultAttribute(Messages.MBeanNotificationLogInspector_TYPE_LABEL, (Object)this.m_notification.getType()));
                this.m_children.add((IReadOnlyAttribute)new DefaultAttribute(Messages.MBeanNotificationLogInspector_SEQUENCE_NUMBER_LABEL, (Object)this.m_notification.getSequenceNumber()));
                this.m_children.add((IReadOnlyAttribute)new DefaultAttribute(Messages.MBeanNotificationLogInspector_MESSAGE_LABEL, (Object)this.m_notification.getMessage()));
                this.m_children.add((IReadOnlyAttribute)new DefaultAttribute(Messages.MBeanNotificationLogInspector_USER_DATA_LABEL, this.m_notification.getUserData()));
            }
            return this.m_children;
        }

        public int hashCode() {
            return this.m_notification.hashCode();
        }

        public boolean equals(Object that) {
            return that instanceof NotificationValue && this.m_notification.equals(((NotificationValue)((Object)that)).m_notification);
        }

        public static synchronized DateFormat getDateFormat() {
            return (DateFormat)DATE_FORMAT.clone();
        }
    }
}

