/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.actions.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.actions.internal.Messages;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationToolkit;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;

public class TriggerActionLogToFile
extends TriggerAction {
    @Override
    public void handleNotificationEvent(TriggerEvent e) {
        String fileName = this.getSetting("filename").getFileName();
        MCFile file = IDESupportToolkit.createFileResource((String)fileName);
        ByteArrayInputStream stream = new ByteArrayInputStream(this.getString(e).getBytes(StandardCharsets.UTF_8));
        String jobName = NLS.bind((String)Messages.TriggerActionLogToFile_JOBNAME, (Object)file.getPath());
        IDESupportToolkit.writeAsJob((String)jobName, (MCFile)file, (InputStream)stream, (boolean)true);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private String getString(TriggerEvent e) {
        StringWriter sw = new StringWriter();
        sw.append(Messages.TriggerActionSystemOut_HEADER);
        sw.append(NotificationToolkit.prettyPrint(e));
        sw.append(Messages.TriggerActionSystemOut_FOOTER);
        return sw.toString();
    }
}

