/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Set;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractSyntheticAttribute;
import org.openjdk.jmc.rjmx.subscription.internal.AttributeValueToolkit;
import org.openjdk.jmc.rjmx.subscription.internal.SyntheticAttributeToolkit;

public class HotSpotLiveSetAttribute
extends AbstractSyntheticAttribute {
    private static final String COM_SUN_MANAGEMENT_GC_NOTIFICATION = "com.sun.management.gc.notification";
    private MBeanServerConnection m_connection = null;
    private Set<ObjectName> m_garbageCollectorMxBeans;
    private final NotificationListener m_listener = this.createListener();
    private Double m_liveSet = null;

    @Override
    public Object getValue(MBeanServerConnection connection) throws MBeanException, ReflectionException {
        return this.m_liveSet;
    }

    @Override
    public void setValue(MBeanServerConnection connection, Object value) throws MBeanException, ReflectionException {
    }

    @Override
    public void init(MBeanServerConnection connection) {
        super.init(connection);
        this.m_connection = connection;
        this.m_garbageCollectorMxBeans = SyntheticAttributeToolkit.lookupMxBeans(this.m_connection, "java.lang", "GarbageCollector");
        this.setInitialValue(this.m_garbageCollectorMxBeans);
        SyntheticAttributeToolkit.subscribeToNotifications(this.m_connection, this.m_listener, this.m_garbageCollectorMxBeans, COM_SUN_MANAGEMENT_GC_NOTIFICATION);
    }

    @Override
    public void stop() {
        SyntheticAttributeToolkit.unsubscribeFromNotifications(this.m_connection, this.m_listener, this.m_garbageCollectorMxBeans);
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                CompositeData userData = (CompositeData)notification.getUserData();
                if (HotSpotLiveSetAttribute.isOldCollection(userData)) {
                    CompositeData gcInfo = (CompositeData)userData.get("gcInfo");
                    HotSpotLiveSetAttribute.this.m_liveSet = HotSpotLiveSetAttribute.calculateLiveSet(gcInfo, HotSpotLiveSetAttribute.this.m_connection);
                }
            }
        };
    }

    private void setInitialValue(Set<ObjectName> garbageCollectorMxBeans) {
        ObjectName majorGcObjectName = this.findMajorGcMbean(garbageCollectorMxBeans);
        if (majorGcObjectName != null) {
            try {
                CompositeData gcInfo = (CompositeData)AttributeValueToolkit.getAttribute(this.m_connection, majorGcObjectName, "LastGcInfo");
                if (gcInfo != null) {
                    this.m_liveSet = HotSpotLiveSetAttribute.calculateLiveSet(gcInfo, this.m_connection);
                }
            }
            catch (Exception exception) {}
        }
    }

    private ObjectName findMajorGcMbean(Set<ObjectName> garbageCollectorMxBeans) {
        int maxGcPools = 0;
        ObjectName majorGcObjectName = null;
        for (ObjectName objectName : garbageCollectorMxBeans) {
            try {
                int gcPools;
                Object poolNames = AttributeValueToolkit.getAttribute(this.m_connection, objectName, "MemoryPoolNames");
                if (!(poolNames instanceof String[]) || (gcPools = ((String[])poolNames).length) <= maxGcPools) continue;
                majorGcObjectName = objectName;
                maxGcPools = gcPools;
            }
            catch (Exception exception) {}
        }
        return majorGcObjectName;
    }

    static Double calculateLiveSet(CompositeData gcInfo, MBeanServerConnection connection) {
        return HotSpotLiveSetAttribute.calculateLiveSet(HotSpotLiveSetAttribute.lookupUsedHeap(gcInfo), connection);
    }

    static Double calculateLiveSet(long usedHeap, MBeanServerConnection connection) {
        long committedHeap = HotSpotLiveSetAttribute.getCommittedHeap(connection);
        if (committedHeap > 0L) {
            return (double)usedHeap / (double)committedHeap;
        }
        return null;
    }

    private static boolean isOldCollection(CompositeData data) {
        return ((String)data.get("gcAction")).indexOf("major") >= 0;
    }

    static long lookupUsedHeap(CompositeData gcInfo) {
        long usedHeap = 0L;
        TabularData memoryUsageAfterGc = (TabularData)gcInfo.get("memoryUsageAfterGc");
        for (Object memoryPool : memoryUsageAfterGc.values()) {
            usedHeap += HotSpotLiveSetAttribute.getMemoryPoolUsed((CompositeData)memoryPool);
        }
        return usedHeap;
    }

    private static long getMemoryPoolUsed(CompositeData memoryPool) {
        if (HotSpotLiveSetAttribute.includeMemoryPool(memoryPool.get("key").toString())) {
            Long memoryPoolUsed = (Long)((CompositeData)memoryPool.get("value")).get("used");
            return memoryPoolUsed;
        }
        return 0L;
    }

    private static boolean includeMemoryPool(String memoryPoolName) {
        if (memoryPoolName.equals("Code Cache")) {
            return false;
        }
        if (memoryPoolName.contains("Perm Gen")) {
            return false;
        }
        return !memoryPoolName.contains("Metaspace");
    }

    private static long getCommittedHeap(MBeanServerConnection connection) {
        try {
            return ((Number)AttributeValueToolkit.getAttribute(connection, new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsage/committed"))).longValue();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public boolean hasResolvedDependencies(MBeanServerConnection connection) {
        return !SyntheticAttributeToolkit.lookupMxBeans(connection, "java.lang", "GarbageCollector").isEmpty();
    }
}

