/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractSyntheticNotification;
import org.openjdk.jmc.rjmx.subscription.internal.HotSpotLiveSetAttribute;
import org.openjdk.jmc.rjmx.subscription.internal.SyntheticAttributeToolkit;

public class HotSpotGcNotification
extends AbstractSyntheticNotification {
    private static final String[] FIELD_NAMES = new String[]{"HeapLiveSet", "HeapLiveSetSize", "Duration"};
    private static final CompositeType TYPE;
    private static final String COM_SUN_MANAGEMENT_GC_NOTIFICATION = "com.sun.management.gc.notification";
    private MBeanServerConnection m_connection;
    private Set<ObjectName> m_garbageCollectorMxBeans;
    private CompositeData m_lastValue;
    private String m_lastMessage;
    private final NotificationListener m_listener = this.createListener();

    static {
        try {
            TYPE = new CompositeType("org.openjdk.jmc.rjmx.subscription.internal.hotspotgcdata", "GC Data", FIELD_NAMES, FIELD_NAMES, new OpenType[]{SimpleType.DOUBLE, SimpleType.LONG, SimpleType.LONG});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(MBeanServerConnection connection, String type, String message) {
        super.init(connection, type, message);
        this.m_connection = connection;
        this.m_garbageCollectorMxBeans = SyntheticAttributeToolkit.lookupMxBeans(this.m_connection, "java.lang", "GarbageCollector");
        SyntheticAttributeToolkit.subscribeToNotifications(this.m_connection, this.m_listener, this.m_garbageCollectorMxBeans, COM_SUN_MANAGEMENT_GC_NOTIFICATION);
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object handback) {
                HotSpotGcNotification hotSpotGcNotification = HotSpotGcNotification.this;
                synchronized (hotSpotGcNotification) {
                    try {
                        CompositeData userData = (CompositeData)notification.getUserData();
                        CompositeData gcInfo = (CompositeData)userData.get("gcInfo");
                        Object[] values = new Object[FIELD_NAMES.length];
                        long usedHeap = HotSpotLiveSetAttribute.lookupUsedHeap(gcInfo);
                        values[0] = HotSpotLiveSetAttribute.calculateLiveSet(usedHeap, HotSpotGcNotification.this.m_connection);
                        values[1] = usedHeap;
                        values[2] = gcInfo.get("duration");
                        HotSpotGcNotification.this.m_lastValue = new CompositeDataSupport(TYPE, FIELD_NAMES, values);
                    }
                    catch (Exception e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to update HotSpotGcNotification value", e);
                    }
                    HotSpotGcNotification.this.m_lastMessage = notification.getMessage();
                }
                HotSpotGcNotification.this.triggerNotification();
            }
        };
    }

    @Override
    protected String getMessage() {
        return this.m_lastMessage;
    }

    @Override
    public Object getValue() {
        return this.m_lastValue;
    }

    @Override
    public void stop() {
        SyntheticAttributeToolkit.unsubscribeFromNotifications(this.m_connection, this.m_listener, this.m_garbageCollectorMxBeans);
    }

    public CompositeType getValueType() {
        return TYPE;
    }

    @Override
    public boolean hasResolvedDependencies(MBeanServerConnection connection) {
        return !SyntheticAttributeToolkit.lookupMxBeans(connection, "java.lang", "GarbageCollector").isEmpty();
    }
}

