/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription;

import java.awt.Color;
import javax.management.Descriptor;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataProvider;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.MRI;

public final class MRIMetadataToolkit {
    private MRIMetadataToolkit() {
        throw new AssertionError((Object)"This is a toolkit! Do not instantiate!");
    }

    public static String getDisplayName(IConnectionHandle handle, MRI mri) {
        return MRIMetadataToolkit.getDisplayName(handle.getServiceOrNull(IMRIMetadataService.class), mri);
    }

    public static String getDisplayName(IMRIMetadataService service, MRI mri) {
        String displayName;
        if (service != null && (displayName = (String)service.getMetadata(mri, "DisplayName")) != null && displayName.trim().length() > 0) {
            return displayName;
        }
        StringBuilder builder = new StringBuilder();
        String attributeDisplayName = mri.getDataPath();
        if (attributeDisplayName == null) {
            return "";
        }
        boolean lastCharLowerCase = false;
        int n = 0;
        while (n < attributeDisplayName.length()) {
            char c = attributeDisplayName.charAt(n);
            if (lastCharLowerCase && Character.isUpperCase(c)) {
                builder.append(' ');
                builder.append(Character.toUpperCase(c));
            } else {
                builder.append(c);
            }
            lastCharLowerCase = Character.isLowerCase(c);
            ++n;
        }
        return builder.toString();
    }

    private static Object getMetadata(IConnectionHandle handle, MRI descriptor, String property) {
        IMRIMetadataService infoService = handle.getServiceOrNull(IMRIMetadataService.class);
        if (infoService != null) {
            return infoService.getMetadata(descriptor, property);
        }
        return null;
    }

    public static String getDescription(IConnectionHandle handle, MRI mri) {
        String str = (String)MRIMetadataToolkit.getMetadata(handle, mri, "Description");
        if (str != null) {
            return str;
        }
        return "";
    }

    public static IMRIMetadata getMRIMetadata(IConnectionHandle handle, MRI descriptor) {
        IMRIMetadataService infoService = handle.getServiceOrNull(IMRIMetadataService.class);
        if (infoService != null) {
            return infoService.getMetadata(descriptor);
        }
        return null;
    }

    public static boolean isNumerical(IMRIMetadata info) {
        return MRIMetadataToolkit.isNumerical(info.getValueType());
    }

    public static boolean isNumerical(String attributeType) {
        if (attributeType == null) {
            return false;
        }
        if (attributeType.equals(Integer.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Float.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Double.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Long.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Short.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Byte.TYPE.getName())) {
            return true;
        }
        try {
            return Number.class.isAssignableFrom(Class.forName(attributeType));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isComposite(IMRIMetadataProvider info) {
        return MRIMetadataToolkit.getBooleanValue(info, "composite");
    }

    public static boolean isCompositeType(String className) {
        block4: {
            if (className == null || className.length() == 0) {
                return false;
            }
            try {
                if (!TypeHandling.isPrimitive((String)className)) break block4;
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return CompositeData.class.isAssignableFrom(Class.forName(className));
    }

    public static boolean isReadable(IMRIMetadataProvider info) {
        return MRIMetadataToolkit.getBooleanValue(info, "Readable");
    }

    public static boolean isWritable(IMRIMetadataProvider info) {
        return MRIMetadataToolkit.getBooleanValue(info, "Writable");
    }

    public static Descriptor getDescriptor(IMRIMetadataProvider info) {
        return (Descriptor)info.getMetadata("Descriptor");
    }

    public static Color getColor(IMRIMetadataProvider info) {
        Object colorStr = info.getMetadata("color");
        if (colorStr != null) {
            return ColorToolkit.decode((String)colorStr.toString());
        }
        return ColorToolkit.getDistinguishableColor((Object)info.getMRI());
    }

    public static boolean getBooleanValue(IMRIMetadataProvider info, String key) {
        Boolean b = (Boolean)info.getMetadata(key);
        if (b != null) {
            return b;
        }
        return false;
    }
}

