/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import org.openjdk.jmc.rjmx.ISyntheticAttribute;
import org.openjdk.jmc.rjmx.subscription.MRI;

public class SyntheticAttributeEntry {
    private final ISyntheticAttribute attribute;
    private final MRI descriptor;
    private final String description;
    private final String type;
    private final boolean readable;
    private final boolean writeable;
    private final boolean isIs;

    public SyntheticAttributeEntry(ISyntheticAttribute attribute, MRI descriptor, String description, String type, boolean readable, boolean writeable, boolean isIs) {
        this.attribute = attribute;
        this.descriptor = descriptor;
        this.description = description;
        this.type = type;
        this.readable = readable;
        this.writeable = writeable;
        this.isIs = isIs;
    }

    public ISyntheticAttribute getAttribute() {
        return this.attribute;
    }

    public String getName() {
        return this.descriptor.getQualifiedName();
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public MRI getAttributeDescriptor() {
        return this.descriptor;
    }

    public boolean isIs() {
        return this.isIs;
    }

    public String toString() {
        return String.valueOf(this.getName()) + '[' + this.type + ", " + this.flags() + ']';
    }

    private String flags() {
        String flags = "";
        if (this.isReadable()) {
            flags = String.valueOf(flags) + 'R';
        }
        if (this.isWriteable()) {
            flags = String.valueOf(flags) + 'W';
        }
        if (this.isIs()) {
            flags = String.valueOf(flags) + 'I';
        }
        return flags;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyntheticAttributeEntry other = (SyntheticAttributeEntry)obj;
        return !(this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor));
    }
}

