/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.support.DupArrayStats;
import org.openjdk.jmc.joverflow.util.ValueWitIntIdMap;
import org.openjdk.jmc.joverflow.util.ValueWithIntId;

class PrimitiveArrayDuplicationMap {
    private final ValueWitIntIdMap<InternalEntry> table;
    private int nTotalArrays;
    private int nUniqueArrays;
    private int currentId = 1;
    private int numDifferentDupArrayValues;
    private ArrayList<DupArrayStats.Entry> dupArrays;
    private long dupArraysOvhd;

    PrimitiveArrayDuplicationMap(Snapshot snapshot) {
        int capacity = snapshot.getNumObjects() / 10;
        this.table = new ValueWitIntIdMap(capacity);
    }

    void add(JavaValueArray array) {
        ++this.nTotalArrays;
        byte[] bytes = array.getValue();
        int checksum = PrimitiveArrayDuplicationMap.checksum(bytes);
        InternalEntry entry = this.table.get(checksum);
        if (entry == null) {
            entry = new InternalEntry(checksum, array, this.currentId++);
            this.table.put(entry);
        } else {
            InternalEntry prevEntry = null;
            while (entry != null) {
                if (entry.firstArray.getClazz() == array.getClazz() && entry.firstArray.getLength() == array.getLength() && Arrays.equals(entry.firstArray.getValue(), bytes)) break;
                prevEntry = entry;
                entry = entry.next;
            }
            if (entry == null) {
                prevEntry.next = entry = new InternalEntry(checksum, array, this.currentId++);
            }
        }
        ++entry.nArrayInst;
        array.setInternalId(entry.uniqueId);
    }

    void calculateFinalStats() {
        ArrayList<DupArrayStats.Entry> result = new ArrayList<DupArrayStats.Entry>(this.table.size() / 20);
        for (InternalEntry entry : this.table.values()) {
            while (entry != null) {
                ++this.nUniqueArrays;
                if (entry.nArrayInst > 1) {
                    int overhead = entry.firstArray.getSize() * (entry.nArrayInst - 1);
                    this.dupArraysOvhd += (long)overhead;
                    result.add(new DupArrayStats.Entry(entry.firstArray, entry.uniqueId, entry.nArrayInst, overhead));
                }
                entry = entry.next;
            }
        }
        Collections.sort(result, new Comparator<DupArrayStats.Entry>(){

            @Override
            public int compare(DupArrayStats.Entry e1, DupArrayStats.Entry e2) {
                if (e1.overhead > e2.overhead) {
                    return -1;
                }
                if (e1.overhead < e2.overhead) {
                    return 1;
                }
                return 0;
            }
        });
        this.dupArrays = result;
        this.numDifferentDupArrayValues = result.size();
    }

    int getNumArrays() {
        return this.nTotalArrays;
    }

    int getNumUniqueArrays() {
        return this.nUniqueArrays;
    }

    int getNumDifferentDupArrayValues() {
        return this.numDifferentDupArrayValues;
    }

    long getDupArraysOverhead() {
        return this.dupArraysOvhd;
    }

    ArrayList<DupArrayStats.Entry> getDupArrays() {
        return this.dupArrays;
    }

    private static int checksum(byte[] bytes) {
        if (bytes.length == 0) {
            return 0;
        }
        int h = 0;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            h = 31 * h + b;
            ++n2;
        }
        return h;
    }

    private static class InternalEntry
    implements ValueWithIntId {
        final int checksum;
        final JavaValueArray firstArray;
        final int uniqueId;
        int nArrayInst;
        InternalEntry next;

        InternalEntry(int checksum, JavaValueArray firstArray, int uniqueId) {
            this.checksum = checksum;
            this.firstArray = firstArray;
            this.uniqueId = uniqueId;
        }

        @Override
        public int getId() {
            return this.checksum;
        }
    }
}

