/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.ArrayList;
import org.openjdk.jmc.joverflow.descriptors.CollectionClassDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionDescriptors;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.stats.InterimRefChain;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.RefChainElementImpl;
import org.openjdk.jmc.joverflow.util.FastStack;
import org.openjdk.jmc.joverflow.util.IndexContainer;

class InterimRefChainStack
extends InterimRefChain {
    private final CollectionDescriptors colDescriptors;
    private final FastStack<Object> refChain = new FastStack(512);
    private final ArrayList<RefChainElement> condensedRefChain;
    private int numCommonRefChainEls;
    private int lastRecordedRefTreeIdx;
    private int[] refChainToRefTreeIdx = new int[16000];

    InterimRefChainStack(ProblemRecorder problemRecorder, CollectionDescriptors colDescriptors) {
        super(problemRecorder);
        this.colDescriptors = colDescriptors;
        this.condensedRefChain = new ArrayList(256);
    }

    @Override
    protected void onCurrentRootReset() {
        this.condensedRefChain.clear();
        this.condensedRefChain.add(this.curCondensedRefChainElement);
    }

    void push(JavaHeapObject javaHeapObj) {
        this.refChain.push(javaHeapObj);
    }

    void pushIndexContainer(IndexContainer idx) {
        this.refChain.push(idx);
    }

    void setCurrentFieldOrArrayIndex(int idx) {
        ((IndexContainer)this.refChain.peek()).set(idx);
    }

    IndexContainer getCurrentIndexContainer() {
        return (IndexContainer)this.refChain.peek();
    }

    void pop() {
        this.refChain.pop();
        if (this.refChain.size() < this.numCommonRefChainEls) {
            this.numCommonRefChainEls = this.refChain.size();
        }
    }

    void pop2() {
        this.refChain.pop();
        this.refChain.pop();
        if (this.refChain.size() < this.numCommonRefChainEls) {
            this.numCommonRefChainEls = this.refChain.size();
        }
    }

    @Override
    protected JavaObject getPointingJavaObject() {
        if (this.refChain.size() < 2) {
            return null;
        }
        Object obj = this.refChain.get(this.refChain.size() - 3);
        if (!(obj instanceof JavaObject)) {
            return null;
        }
        return (JavaObject)obj;
    }

    int size() {
        return this.refChain.size();
    }

    JavaHeapObject peekJavaHeapObject(int idxFromBack) {
        return (JavaHeapObject)this.refChain.get(this.refChain.size() - 1 - idxFromBack);
    }

    int peekIndex(int idxFromBack) {
        return ((IndexContainer)this.refChain.get(this.refChain.size() - 1 - idxFromBack)).get();
    }

    @Override
    protected RefChainElement getLastRefChainElement() {
        if (this.refChainToRefTreeIdx.length < this.refChain.size()) {
            int[] old = this.refChainToRefTreeIdx;
            this.refChainToRefTreeIdx = new int[this.refChain.size() * 5 / 4];
            System.arraycopy(old, 0, this.refChainToRefTreeIdx, 0, old.length);
        }
        int chainSizeMinusOne = this.refChain.size() - 1;
        RefChainElement curRefChainElement = this.curCondensedRefChainElement;
        if (this.newGCRoot || this.numCommonRefChainEls == 0) {
            this.newGCRoot = false;
            int refTreeElementIdx = -1;
            int i = 0;
            while (i < chainSizeMinusOne) {
                ++refTreeElementIdx;
                CollapsedObj clpsObj = this.collapseLinkedListImpl(i, curRefChainElement);
                if (clpsObj == null) {
                    clpsObj = this.collapseCollectionImpl(i, curRefChainElement);
                }
                if (clpsObj != null) {
                    curRefChainElement = clpsObj.desc;
                    int j = i;
                    while (j <= clpsObj.endIdx) {
                        this.refChainToRefTreeIdx[j] = refTreeElementIdx;
                        ++j;
                    }
                    i = clpsObj.endIdx;
                } else {
                    int n = refTreeElementIdx;
                    this.refChainToRefTreeIdx[i + 1] = n;
                    this.refChainToRefTreeIdx[i] = n;
                    JavaHeapObject javaHeapObj = (JavaHeapObject)this.refChain.get(i++);
                    int fieldOrArrIdx = ((IndexContainer)this.refChain.get(i)).get();
                    curRefChainElement = this.getLinkDesc(javaHeapObj, fieldOrArrIdx, curRefChainElement);
                }
                this.condensedRefChain.add(curRefChainElement);
                ++i;
            }
            this.lastRecordedRefTreeIdx = refTreeElementIdx;
            this.numCommonRefChainEls = chainSizeMinusOne;
            this.curCondensedRefChainElement = curRefChainElement;
            return curRefChainElement;
        }
        int lastCommonRefChainIdx = this.numCommonRefChainEls - 1;
        if ((lastCommonRefChainIdx & 1) == 1) {
            --lastCommonRefChainIdx;
        }
        lastCommonRefChainIdx = this.skipBackPotentialCollectionImplOrLinkedList(lastCommonRefChainIdx);
        int startIdx = (lastCommonRefChainIdx -= 2) == 0 ? 0 : lastCommonRefChainIdx + 2;
        int nStepsBack = startIdx > 0 ? this.lastRecordedRefTreeIdx - this.refChainToRefTreeIdx[lastCommonRefChainIdx] : this.lastRecordedRefTreeIdx + 1;
        int refTreeElementIdx = startIdx > 0 ? this.refChainToRefTreeIdx[lastCommonRefChainIdx] : -1;
        int lastIndex = this.condensedRefChain.size() - 1;
        int i = 0;
        while (i < nStepsBack) {
            this.condensedRefChain.remove(lastIndex);
            ++i;
            --lastIndex;
        }
        curRefChainElement = this.condensedRefChain.get(lastIndex);
        i = startIdx;
        while (i < chainSizeMinusOne) {
            ++refTreeElementIdx;
            CollapsedObj clpsObj = this.collapseLinkedListImpl(i, curRefChainElement);
            if (clpsObj == null) {
                clpsObj = this.collapseCollectionImpl(i, curRefChainElement);
            }
            boolean stitchingLinkedListParts = false;
            if (clpsObj != null) {
                if (curRefChainElement == clpsObj.desc) {
                    --refTreeElementIdx;
                    stitchingLinkedListParts = true;
                } else {
                    curRefChainElement = clpsObj.desc;
                }
                int j = i;
                while (j <= clpsObj.endIdx) {
                    this.refChainToRefTreeIdx[j] = refTreeElementIdx;
                    ++j;
                }
                i = clpsObj.endIdx;
            } else {
                int n = refTreeElementIdx;
                this.refChainToRefTreeIdx[i + 1] = n;
                this.refChainToRefTreeIdx[i] = n;
                JavaHeapObject javaHeapObj = (JavaHeapObject)this.refChain.get(i++);
                int idx = ((IndexContainer)this.refChain.get(i)).get();
                curRefChainElement = this.getLinkDesc(javaHeapObj, idx, curRefChainElement);
            }
            if (!stitchingLinkedListParts) {
                this.condensedRefChain.add(curRefChainElement);
            }
            ++i;
        }
        this.lastRecordedRefTreeIdx = refTreeElementIdx;
        this.numCommonRefChainEls = chainSizeMinusOne;
        this.curCondensedRefChainElement = curRefChainElement;
        return curRefChainElement;
    }

    private int skipBackPotentialCollectionImplOrLinkedList(int idx) {
        int llStepsBack = 0;
        while (true) {
            if (idx <= 2) {
                return idx;
            }
            IndexContainer idx1 = (IndexContainer)this.refChain.get(idx + 1);
            IndexContainer idx0 = (IndexContainer)this.refChain.get(idx - 1);
            JavaHeapObject obj1 = (JavaHeapObject)this.refChain.get(idx);
            JavaHeapObject obj0 = (JavaHeapObject)this.refChain.get(idx - 2);
            if (idx0.get() == idx1.get() && obj1.getClazz() == obj0.getClazz()) {
                idx -= 2;
                if (++llStepsBack <= 2) continue;
                return idx;
            }
            String className = obj1.getClazz().getName();
            if (className.charAt(0) == '[' || className.contains("$")) {
                idx -= 2;
                continue;
            }
            CollectionClassDescriptor colDesc = this.colDescriptors.getClassDescriptor(className);
            if (colDesc == null || !colDesc.isInImplementationOf(obj0.getClazz().getName())) break;
            idx -= 2;
        }
        return idx;
    }

    private CollapsedObj collapseCollectionImpl(int startIdx, RefChainElement referer) {
        JavaHeapObject javaHeapObj = (JavaHeapObject)this.refChain.get(startIdx);
        if (!(javaHeapObj instanceof JavaObject)) {
            return null;
        }
        JavaObject javaObj = (JavaObject)javaHeapObj;
        CollectionClassDescriptor colDesc = this.colDescriptors.getClassDescriptor(javaObj);
        if (colDesc == null) {
            return null;
        }
        int refChainIdx = startIdx + 2;
        if (refChainIdx >= this.refChain.size()) {
            return null;
        }
        JavaHeapObject obj = (JavaHeapObject)this.refChain.get(refChainIdx);
        String objClassName = obj.getClazz().getName();
        if (!colDesc.isImplClassName(objClassName) && !objClassName.equals("[Ljava.lang.Object;")) {
            return null;
        }
        refChainIdx = startIdx + 4;
        int refChainSize = this.refChain.size();
        if (refChainIdx >= refChainSize) {
            return new CollapsedObj(javaObj.getClazz(), refChainSize - 1, referer);
        }
        obj = (JavaHeapObject)this.refChain.get(refChainIdx);
        objClassName = obj.getClazz().getName();
        while (colDesc.isImplClassName(objClassName)) {
            if ((refChainIdx += 2) >= refChainSize) break;
            objClassName = ((JavaHeapObject)this.refChain.get(refChainIdx)).getClazz().getName();
        }
        return new CollapsedObj(javaObj.getClazz(), refChainIdx - 1, referer);
    }

    private CollapsedObj collapseLinkedListImpl(int startIdx, RefChainElement referer) {
        RefChainElementImpl.Collection otherCol;
        CollectionClassDescriptor colDesc;
        JavaClass llClazz;
        JavaClass elementClass1;
        int fieldIdx1;
        JavaHeapObject javaHeapObj = (JavaHeapObject)this.refChain.get(startIdx);
        if (!(javaHeapObj instanceof JavaObject)) {
            return null;
        }
        int refChainLastIdx = this.refChain.size() - 1;
        if (startIdx + 3 >= refChainLastIdx) {
            return null;
        }
        int refChainIdx = startIdx;
        int fieldIdx = ((IndexContainer)this.refChain.get(startIdx + 1)).get();
        JavaClass elementClass = javaHeapObj.getClazz();
        JavaClass llDefiningClass = elementClass.getDeclaringClassForField(fieldIdx);
        while ((fieldIdx1 = ((IndexContainer)this.refChain.get(refChainIdx + 3)).get()) == fieldIdx && (elementClass1 = (javaHeapObj = (JavaHeapObject)this.refChain.get(refChainIdx + 2)).getClazz()).getDeclaringClassForField(fieldIdx) == llDefiningClass) {
            if (elementClass != null && elementClass1 != elementClass) {
                elementClass = null;
            }
            if ((refChainIdx += 2) + 3 <= refChainLastIdx) continue;
        }
        if (refChainIdx == startIdx) {
            return null;
        }
        JavaClass javaClass = llClazz = elementClass != null ? elementClass : llDefiningClass;
        if (referer instanceof RefChainElementImpl.InstanceFieldOrLinkedList) {
            RefChainElementImpl.InstanceFieldOrLinkedList otherList = (RefChainElementImpl.InstanceFieldOrLinkedList)referer;
            if (!otherList.isInstanceField() && otherList.getJavaClass() == llClazz && otherList.getFieldIdx() == fieldIdx) {
                return new CollapsedObj(refChainIdx + 1, referer);
            }
        } else if (referer instanceof RefChainElementImpl.Collection && (colDesc = this.colDescriptors.getClassDescriptor((otherCol = (RefChainElementImpl.Collection)referer).getJavaClass().getName())) != null && colDesc.isImplClassName(llClazz.getName())) {
            JavaHeapObject lastObj = (JavaHeapObject)this.refChain.get(refChainIdx + 2);
            if (colDesc.isImplClassName(lastObj.getClazz().getName())) {
                refChainIdx += 2;
            }
            int endIdx = refChainIdx + 1 < this.refChain.size() ? refChainIdx + 1 : refChainIdx;
            return new CollapsedObj(endIdx, referer);
        }
        return new CollapsedObj(llClazz, fieldIdx, refChainIdx + 1, referer);
    }

    private String getFullLinkDesc(JavaHeapObject javaHeapObj, int idx) {
        if (javaHeapObj instanceof JavaObject) {
            JavaObject javaObj = (JavaObject)javaHeapObj;
            return String.valueOf(javaObj.getClazz().getName()) + '.' + this.getFieldDesc(javaObj, idx);
        }
        if (javaHeapObj instanceof JavaClass) {
            JavaClass clazz = (JavaClass)javaHeapObj;
            return String.valueOf(clazz.getName()) + ':' + this.getStaticFieldDesc(clazz, idx);
        }
        if (javaHeapObj instanceof JavaObjectArray) {
            JavaObjectArray arrayObj = (JavaObjectArray)javaHeapObj;
            return String.valueOf(arrayObj.getClazz().getName()) + '[' + idx + ']';
        }
        return null;
    }

    private RefChainElement getLinkDesc(JavaHeapObject javaHeapObj, int idx, RefChainElement referer) {
        if (javaHeapObj instanceof JavaObject) {
            return RefChainElementImpl.getInstanceFieldElement(javaHeapObj.getClazz(), idx, referer);
        }
        if (javaHeapObj instanceof JavaClass) {
            JavaClass clazz = (JavaClass)javaHeapObj;
            return RefChainElementImpl.getStaticFieldElement(clazz, idx, referer);
        }
        if (javaHeapObj instanceof JavaObjectArray) {
            return RefChainElementImpl.getCompoundArrayElement(javaHeapObj.getClazz(), referer);
        }
        throw new RuntimeException("JavaHeapObject of wrong type is supplied: " + javaHeapObj);
    }

    private String getFieldDesc(JavaObject javaObj, int idx) {
        JavaClass clazz = javaObj.getClazz();
        return clazz.getFieldForInstance(idx).getName();
    }

    private String getStaticFieldDesc(JavaClass clazz, int idx) {
        JavaField[] statics = clazz.getStaticFields();
        return statics[idx].getName();
    }

    public void printFullRefChain() {
        System.out.print(this.curRootRefChainElement.getRoot().getTypeName());
        System.out.print("  ");
        int chainSizeMinusOne = this.refChain.size() - 1;
        int i = 0;
        while (i < chainSizeMinusOne) {
            JavaHeapObject javaHeapObj = (JavaHeapObject)this.refChain.get(i++);
            int idx = ((IndexContainer)this.refChain.get(i)).get();
            System.out.print("-->" + this.getFullLinkDesc(javaHeapObj, idx));
            ++i;
        }
        System.out.println();
    }

    /*
     * Unable to fully structure code
     */
    StringBuilder getPrintableCondensedRefChain() {
        block6: {
            result = new StringBuilder(160);
            result.append(this.curRootRefChainElement.getRoot().getTypeName()).append('@').append(this.curRootRefChainElement.getRoot().getId());
            result.append(" ");
            chainSizeMinusOne = this.refChain.size() - 1;
            startIdx = chainSizeMinusOne - 16;
            if (startIdx > 0) ** GOTO lbl-1000
            startIdx = 0;
            break block6;
            while ((startIdx -= 2) != 0) lbl-1000:
            // 2 sources

            {
                if (((JavaHeapObject)this.refChain.get(startIdx)).getClazz().getName().indexOf(36) > 0) continue;
            }
            if (startIdx > 0) {
                result.append("-->...");
            }
        }
        i = startIdx;
        while (i < chainSizeMinusOne) {
            clpsObj = this.collapseLinkedListImpl(i, null);
            if (clpsObj == null) {
                clpsObj = this.collapseCollectionImpl(i, null);
            }
            if (clpsObj != null) {
                result.append(clpsObj.desc.toString());
                i = clpsObj.endIdx;
            } else {
                javaHeapObj = (JavaHeapObject)this.refChain.get(i++);
                idx = ((IndexContainer)this.refChain.get(i)).get();
                result.append("-->");
                result.append(this.getLinkDesc(javaHeapObj, idx, null));
            }
            ++i;
        }
        lastObj = (JavaHeapObject)this.refChain.get(chainSizeMinusOne);
        shortClassName = lastObj.getClazz().getHumanFriendlyName();
        result.append("->>").append(shortClassName);
        return result;
    }

    private static class CollapsedObj {
        RefChainElement desc;
        int endIdx;

        CollapsedObj(JavaClass clazz, int endIdx, RefChainElement referer) {
            this.desc = RefChainElementImpl.getCompoundCollectionElement(clazz, referer);
            this.endIdx = endIdx;
        }

        CollapsedObj(JavaClass clazz, int fieldIdx, int endIdx, RefChainElement referer) {
            this.desc = RefChainElementImpl.getCompoundLinkedListElement(clazz, fieldIdx, referer);
            this.endIdx = endIdx;
        }

        CollapsedObj(int endIdx, RefChainElement desc) {
            this.desc = desc;
            this.endIdx = endIdx;
        }
    }
}

