/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;

class JavaObjectTable {
    private static final int CHUNK_MAGNITUDE = 20;
    private static final int CHUNK_SIZE = 0x100000;
    private static final int POS_IN_CHUNK_MASK = 1048575;
    private static final long LONG_LOW_WORD_MASK = 0xFFFFFFFFL;
    private final int classIdxShift;
    private final int arrayMask;
    private final int objOfsHighWordMask;
    private final int[][] objects;
    private final JavaClass[] classes;
    private final int numObjs;
    private final int lastObjEndPos;

    private JavaObjectTable(int[][] objects, JavaClass[] classes, int numObjs, int lastObjEndPos, int classIdxShift, int arrayMask) {
        this.objects = objects;
        this.classes = classes;
        this.numObjs = numObjs;
        this.lastObjEndPos = lastObjEndPos;
        this.classIdxShift = classIdxShift;
        this.arrayMask = arrayMask;
        this.objOfsHighWordMask = arrayMask - 1;
    }

    JavaLazyReadObject getObject(int objPosInTable) {
        boolean isArray;
        int posInCurChunk;
        int chunkIdx = objPosInTable >> 20;
        int[] chunk = this.objects[chunkIdx];
        int startPosInCurChunk = posInCurChunk = objPosInTable & 0xFFFFF;
        int classAndOfsWord1 = chunk[posInCurChunk++];
        int classAndOfsWord2 = chunk[posInCurChunk++];
        long objOfsInFile = (long)classAndOfsWord2 & 0xFFFFFFFFL | (long)(classAndOfsWord1 & this.objOfsHighWordMask) << 32;
        int classIdx = classAndOfsWord1 >>> this.classIdxShift;
        JavaClass clazz = this.classes[classIdx];
        boolean bl = isArray = (classAndOfsWord1 & this.arrayMask) != 0;
        if (isArray) {
            int length = chunk[posInCurChunk + 1];
            if (clazz.isSingleDimPrimitiveArray()) {
                return new JavaValueArray(clazz, objOfsInFile, length, chunk, startPosInCurChunk, objPosInTable);
            }
            return new JavaObjectArray(clazz, objOfsInFile, length, chunk, startPosInCurChunk, objPosInTable);
        }
        return new JavaObject(clazz, objOfsInFile, chunk, startPosInCurChunk, objPosInTable);
    }

    int size() {
        return this.numObjs;
    }

    Collection<JavaLazyReadObject> getObjects() {
        return new AbstractCollection<JavaLazyReadObject>(){

            @Override
            public Iterator<JavaLazyReadObject> iterator() {
                return new Iterator<JavaLazyReadObject>(){
                    private int curObjPos = 1;
                    private int curChunk = 0;
                    private int curChunkEndPos = 1048575;

                    @Override
                    public boolean hasNext() {
                        return this.curObjPos < JavaObjectTable.this.lastObjEndPos;
                    }

                    @Override
                    public JavaLazyReadObject next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        JavaLazyReadObject result = JavaObjectTable.this.getObject(this.curObjPos);
                        this.curObjPos = result instanceof JavaObject ? (this.curObjPos += 3) : (this.curObjPos += 4);
                        if (this.curObjPos > this.curChunkEndPos - 3) {
                            ++this.curChunk;
                            this.curObjPos = this.curChunk * 0x100000;
                            this.curChunkEndPos = this.curObjPos + 0x100000 - 1;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return JavaObjectTable.this.numObjs;
            }
        };
    }

    Collection<JavaLazyReadObject> getUnvisitedObjects() {
        return new AbstractCollection<JavaLazyReadObject>(){

            @Override
            public Iterator<JavaLazyReadObject> iterator() {
                class UnvisitedObjIterator
                implements Iterator<JavaLazyReadObject> {
                    private int curChunk = 0;
                    private int curChunkEndPos = 1048575;
                    private int curObjPos = 1;

                    UnvisitedObjIterator() {
                        this.moveToNextUnvisitedObjectIfNeeded();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.curObjPos < JavaObjectTable.this.lastObjEndPos;
                    }

                    @Override
                    public JavaLazyReadObject next() {
                        JavaLazyReadObject result = JavaObjectTable.this.getObject(this.curObjPos);
                        this.curObjPos = result instanceof JavaObject ? (this.curObjPos += 3) : (this.curObjPos += 4);
                        this.moveToNextUnvisitedObjectIfNeeded();
                        return result;
                    }

                    private void moveToNextUnvisitedObjectIfNeeded() {
                        while (this.curObjPos < JavaObjectTable.this.lastObjEndPos) {
                            if (this.curObjPos > this.curChunkEndPos - 3) {
                                ++this.curChunk;
                                this.curObjPos = this.curChunk * 0x100000;
                                this.curChunkEndPos = this.curObjPos + 0x100000 - 1;
                            }
                            if (!this.curObjIsVisited()) break;
                            if (this.curObjIsArray()) {
                                this.curObjPos += 4;
                                continue;
                            }
                            this.curObjPos += 3;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private boolean curObjIsVisited() {
                        return JavaLazyReadObject.isVisited(JavaObjectTable.this.objects[this.curChunk][(this.curObjPos & 0xFFFFF) + 2]);
                    }

                    private boolean curObjIsArray() {
                        int firstWord = JavaObjectTable.this.objects[this.curChunk][this.curObjPos & 0xFFFFF];
                        return (firstWord & JavaObjectTable.this.arrayMask) != 0;
                    }
                }
                return new UnvisitedObjIterator();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /* synthetic */ JavaObjectTable(int[][] nArray, JavaClass[] javaClassArray, int n, int n2, int n3, int n4, JavaObjectTable javaObjectTable) {
        this(nArray, javaClassArray, n, n2, n3, n4);
    }

    static class Builder {
        private final int classIdxShift;
        private final int arrayMask;
        private final ArrayList<int[]> chunksAsList;
        private int curChunkIdx = -1;
        private int[] curChunk;
        private int posInCurChunk;
        private int numObjs;

        Builder(long hprofFileSize) {
            int nObjOfsBits = 0;
            while (hprofFileSize > 0L) {
                ++nObjOfsBits;
                hprofFileSize >>= 1;
            }
            this.classIdxShift = nObjOfsBits > 32 ? nObjOfsBits - 31 : 1;
            this.arrayMask = 1 << this.classIdxShift - 1;
            this.chunksAsList = new ArrayList();
            this.addChunk();
            this.posInCurChunk = 1;
        }

        JavaObjectTable buildJavaObjectTable(JavaClass[] classes) {
            int[][] objects = (int[][])this.chunksAsList.toArray((T[])new int[this.chunksAsList.size()][]);
            int lastObjEndPos = this.curChunkIdx * 0x100000 + this.posInCurChunk;
            return new JavaObjectTable(objects, classes, this.numObjs, lastObjEndPos, this.classIdxShift, this.arrayMask, null);
        }

        int addJavaObject(int classIdx, long objOfsInFile) {
            if (this.posInCurChunk > 1048572) {
                this.addChunk();
            }
            int curAbsPos = this.curChunkIdx * 0x100000 + this.posInCurChunk;
            this.addClassAndOfs(classIdx, objOfsInFile, false);
            ++this.posInCurChunk;
            return curAbsPos;
        }

        int addJavaArray(int classIdx, long objOfsInFile, int length) {
            if (this.posInCurChunk > 1048572) {
                this.addChunk();
            }
            int curAbsPos = this.curChunkIdx * 0x100000 + this.posInCurChunk;
            this.addClassAndOfs(classIdx, objOfsInFile, true);
            ++this.posInCurChunk;
            this.addInt(length);
            return curAbsPos;
        }

        int getNumObjects() {
            return this.numObjs;
        }

        private void addClassAndOfs(int classIdx, long objOfsInFile, boolean isArray) {
            ++this.numObjs;
            this.curChunk[this.posInCurChunk++] = (int)(objOfsInFile >> 32) | classIdx << this.classIdxShift | (isArray ? this.arrayMask : 0);
            this.curChunk[this.posInCurChunk++] = (int)objOfsInFile;
        }

        private void addInt(int intNum) {
            this.curChunk[this.posInCurChunk++] = intNum;
        }

        private void addChunk() {
            ++this.curChunkIdx;
            this.curChunk = new int[0x100000];
            this.chunksAsList.add(this.curChunk);
            this.posInCurChunk = 0;
        }
    }
}

