/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.model;

import org.openjdk.jmc.joverflow.heap.model.ImplInclusiveSizeCalculator;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaInt;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;

public class HeapStringReader
implements ImplInclusiveSizeCalculator {
    private final int stringValueIdx;
    private final int stringOffsetIdx;
    private final int stringCountIdx;
    private byte[] byteBuf = new byte[200];
    private char[] charBuf = new char[100];
    private JavaThing[] fields;
    private JavaValueArray valueArray;

    HeapStringReader(Snapshot snapshot) {
        JavaClass stringClass = snapshot.getClassForName("java.lang.String");
        this.stringValueIdx = stringClass.getInstanceFieldIndex("value");
        this.stringOffsetIdx = stringClass.getInstanceFieldIndexOrMinusOne("offset");
        this.stringCountIdx = stringClass.getInstanceFieldIndexOrMinusOne("count");
        stringClass.setImplInclusiveSizeCalculator(this);
    }

    public String readString(JavaObject strObj) {
        this.fields = strObj.getFields(this.fields);
        JavaThing stringValueField = this.fields[this.stringValueIdx];
        if (stringValueField == null || !(stringValueField instanceof JavaValueArray)) {
            return null;
        }
        this.valueArray = (JavaValueArray)stringValueField;
        int offset = 0;
        int count = this.valueArray.getLength();
        if (this.stringOffsetIdx != -1) {
            offset = ((JavaInt)this.fields[this.stringOffsetIdx]).getValue();
            count = ((JavaInt)this.fields[this.stringCountIdx]).getValue();
        }
        this.readCharElements(offset, count);
        return new String(this.charBuf, 0, count);
    }

    public JavaValueArray getLastReadBackingArray() {
        return this.valueArray;
    }

    public JavaValueArray getCharArrayForString(JavaObject strObj) {
        this.fields = strObj.getFields(this.fields);
        JavaThing stringValueField = this.fields[this.stringValueIdx];
        if (stringValueField == null || !(stringValueField instanceof JavaValueArray)) {
            return null;
        }
        return (JavaValueArray)stringValueField;
    }

    private void readCharElements(int offset, int count) {
        int byteBufLen;
        if (this.charBuf.length < count) {
            this.charBuf = new char[count];
        }
        boolean isCompressedString = this.valueArray.getClazz().isByteArray();
        int len = this.valueArray.getLength();
        if (isCompressedString) {
            if (this.byteBuf.length < len) {
                this.byteBuf = new byte[len];
            }
        } else if (this.byteBuf.length < len * 2) {
            this.byteBuf = new byte[len * 2];
        }
        if ((byteBufLen = this.valueArray.readValue(this.byteBuf)) > this.byteBuf.length) {
            throw new RuntimeException("Unexpected length: " + byteBufLen);
        }
        if (isCompressedString) {
            int byteIdx = offset;
            int charIdx = 0;
            while (charIdx < count) {
                this.charBuf[charIdx] = (char)(this.byteBuf[byteIdx++] & 0xFF);
                ++charIdx;
            }
        } else {
            int byteIdx = offset * 2;
            int charIdx = 0;
            while (charIdx < count) {
                int b1 = this.byteBuf[byteIdx++] & 0xFF;
                int b2 = this.byteBuf[byteIdx++] & 0xFF;
                this.charBuf[charIdx] = (char)((b1 << 8) + b2);
                ++charIdx;
            }
        }
    }

    @Override
    public int calculateImplInclusiveSize(JavaObject javaObj) {
        int result = javaObj.getSize();
        JavaValueArray charArray = this.getCharArrayForString(javaObj);
        if (charArray != null) {
            result += charArray.getSize();
        }
        return result;
    }
}

