/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import oracle.jrockit.jfr.DCmd;
import oracle.jrockit.jfr.DCmdException;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.VMJFR;

final class DCmdStop
extends DCmd {
    DCmdStop(VMJFR vMJFR) {
        super(vMJFR);
    }

    public void execute(String string, long l, boolean bl, String string2, boolean bl2) throws DCmdException {
        DCmd.RecordingIdentifier recordingIdentifier = DCmd.RecordingIdentifier.createValid(string, l);
        Recording recording = null;
        try {
            recording = this.findRecording(recordingIdentifier);
            if (bl) {
                recording.setDestination(null);
            }
            recording.setStartTime(null);
            try {
                recording.stop();
            }
            catch (IOException iOException) {
                throw new DCmdException(iOException, "Problem when stopping or writing %s. %s.", recording, this.formatException(iOException));
            }
            catch (IllegalStateException illegalStateException) {
                this.jfrMBean.close(recording);
                string2 = null;
            }
            this.print("Stopped %s", recordingIdentifier);
            if (string2 != null) {
                this.print(", ");
                this.writeToDisk(recording, string2, bl2, recordingIdentifier);
            } else {
                this.println(".", new Object[0]);
            }
        }
        catch (IOException iOException) {
            throw new DCmdException(iOException, "Problem when writing %s. %s.", recording, this.formatException(iOException));
        }
        if (recording != null) {
            this.jfrMBean.close(recording);
        }
    }
}

