/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.StringStore;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public final class Stylesheet {
    public static final int BINARY_CSS_VERSION = 3;
    private final URL url;
    private Origin origin = Origin.AUTHOR;
    private final ObservableList<Rule> rules = new TrackableObservableList<Rule>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Rule> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Rule rule : change.getAddedSubList()) {
                        rule.setStylesheet(Stylesheet.this);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (Rule rule : change.getRemoved()) {
                    if (rule.getStylesheet() != Stylesheet.this) continue;
                    rule.setStylesheet(null);
                }
            }
        }
    };

    public URL getUrl() {
        return this.url;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public Stylesheet() {
        this(null);
    }

    public Stylesheet(URL uRL) {
        this.url = uRL;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Stylesheet) {
            Stylesheet stylesheet = (Stylesheet)object;
            return this.url == null ? stylesheet.url == null : this.url.equals(stylesheet.url);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/* ");
        if (this.url != null) {
            stringBuilder.append(this.url);
        }
        if (this.rules.isEmpty()) {
            stringBuilder.append(" */");
        } else {
            stringBuilder.append(" */\n");
            for (int i = 0; i < this.rules.size(); ++i) {
                stringBuilder.append(this.rules.get(i));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        int n = stringStore.addString(this.origin.name());
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(this.rules.size());
        for (Rule rule : this.rules) {
            rule.writeBinary(dataOutputStream, stringStore);
        }
    }

    public void readBinary(int n, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        short s = dataInputStream.readShort();
        this.setOrigin(Origin.valueOf(stringArray[s]));
        int n2 = dataInputStream.readShort();
        ArrayList<Rule> arrayList = new ArrayList<Rule>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(Rule.readBinary(n, dataInputStream, stringArray));
        }
        this.rules.addAll((Collection<Rule>)arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stylesheet loadBinary(URL uRL) {
        if (uRL == null) {
            return null;
        }
        Stylesheet stylesheet = null;
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = uRL.openStream();
            bufferedInputStream = new BufferedInputStream(inputStream, 40960);
            filterInputStream = new DataInputStream(bufferedInputStream);
            short s = ((DataInputStream)filterInputStream).readShort();
            if (s > 3) {
                throw new IOException(uRL.toString() + " wrong binary CSS version: " + s + ". Expected version less than or equal to" + 3);
            }
            String[] stringArray = StringStore.readBinary((DataInputStream)filterInputStream);
            stylesheet = new Stylesheet(uRL);
            if (s == 2) {
                boolean bl = false;
                try {
                    filterInputStream.mark(Integer.MAX_VALUE);
                    stylesheet.readBinary(s, (DataInputStream)filterInputStream, stringArray);
                }
                catch (Exception exception) {
                    stylesheet = new Stylesheet(uRL);
                    filterInputStream.reset();
                    stylesheet.readBinary(3, (DataInputStream)filterInputStream, stringArray);
                }
            } else {
                stylesheet.readBinary(3, (DataInputStream)filterInputStream, stringArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace(System.err);
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return stylesheet;
    }

    public static enum Origin {
        USER_AGENT,
        USER,
        AUTHOR,
        INLINE;

    }
}

